/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingPublicCrafter;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobEnchanter;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingEnchanter
extends AbstractBuildingWorker
implements IBuildingPublicCrafter {
    private static final String ENCHANTER = "enchanter";
    private static final int MAX_BUILDING_LEVEL = 5;

    public BuildingEnchanter(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> stack.func_77973_b() == ModItems.ancientTome, new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobEnchanter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return ENCHANTER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Mana;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Knowledge;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return ENCHANTER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.enchanter;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        @Override
        @Nullable
        public IJob<?> getCraftingJob() {
            return this.getMainBuildingJob().orElseGet(() -> new JobEnchanter(null));
        }

        @Override
        public boolean addRecipe(IToken<?> token) {
            return false;
        }
    }

    public static class View
    extends AbstractBuildingWorkerView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingEnchanter.ENCHANTER);
        }
    }
}

